#include <stdio.h>
#include <mpi.h>
#include <stdlib.h>
#include <math.h>
#include <stdbool.h>
#include <time.h>
#define total_number_of_rectangles 10000 // Number of rectangles to divide interval

double interval_start;
double interval_end;
double rectangle_width;
double step;

double CalculateIntegration(double start, double end)
{
    double result = 0.0;

    for (double i = start; i < end; i += step)
    {
        double mid = (i + i + 1) / 2.0;
        mid /= total_number_of_rectangles;
        double y = mid * mid;
        result += y * rectangle_width;
    }
    return result;
}

int main(int argc, char* argv[])
{
    interval_start = 0;
    interval_end = 1;
    rectangle_width = (interval_end - interval_start) / total_number_of_rectangles;
    step = rectangle_width * total_number_of_rectangles;

    int my_rank, world_size;
    double sum = 0.0;
    double localSum = 0.0;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &my_rank);
    MPI_Comm_size(MPI_COMM_WORLD, &world_size);

    double start = interval_start * total_number_of_rectangles + my_rank * (interval_end - interval_start) * total_number_of_rectangles / world_size;
    double end = start + (interval_end - interval_start) * total_number_of_rectangles / world_size;

    double time = 0.0;
    MPI_Barrier(MPI_COMM_WORLD);
    time -= MPI_Wtime();

    localSum = CalculateIntegration(start, end);
    MPI_Reduce(&localSum, &sum, 1, MPI_DOUBLE, MPI_SUM, 0, MPI_COMM_WORLD);

    time += MPI_Wtime();

    if (my_rank == 0)
    {
        printf("\n\nNumerical Integral using MPI: value is %lf and time taken is %lf: \n", sum , time);
        printf("***This Program is written by Mohammed Salameh, It Works for Any Interval*** \n");
    }

    MPI_Finalize();

    return 0;
}